// SettingsDialog.cpp : implementation file
//
// Copyright (c) 2000-2001 Marc Ramsey. All rights reserved.
//
// http://www.ranlog.com/ramsey/
//
// This software is provided as is with no warranties of any kind, 
// including the warranties of design, merchantibility and fitness 
// for a particular purpose, noninfringement, or arising from a 
// course of dealing, usage or trade practice.  This software is 
// provided with no support and without any obligation to assist in 
// its use, correction, modification, or enhancement.
//
// Permission to use, copy, or modify this software for any purpose 
// is hereby granted without fee, provided the above notices are 
// retained on all copies of the source code. 

#include "stdafx.h"
#include "IGCshell.h"
#include "SettingsDlg.h"
#include "DirDialog.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern CIGCshellApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CSettingsDialog dialog


CSettingsDialog::CSettingsDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CSettingsDialog::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSettingsDialog)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void CSettingsDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSettingsDialog)
	DDX_Control(pDX, IDC_SET_IGC_DIR, mIGCDLLDir);
	DDX_Control(pDX, IDC_SET_DOWNLOAD_DIR, mDownloadDir);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSettingsDialog, CDialog)
	//{{AFX_MSG_MAP(CSettingsDialog)
	ON_BN_CLICKED(IDC_SET_DOWNLOAD_BROWSE, OnDownloadBrowse)
	ON_BN_CLICKED(IDC_SET_IGCDLL_BROWSE, OnIGCDLLBrowse)
	ON_WM_HELPINFO()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSettingsDialog message handlers

void CSettingsDialog::OnDownloadBrowse() 
{
	// Display select folder dialog
	CString title, path;
	title.LoadString(IDS_DOWNLOAD_FOLDER);
	mDownloadDir.GetWindowText(path);
	CDirDialog dlg(path, NULL, this);
	dlg.m_ofn.lpstrTitle = title;
	if (dlg.DoModal() == IDOK)
		mDownloadDir.SetWindowText(dlg.GetPath());
}

void CSettingsDialog::OnIGCDLLBrowse() 
{
	// Display select folder dialog
	CString title, path;
	title.LoadString(IDS_DLL_FOLDER);
	mIGCDLLDir.GetWindowText(path);
	CDirDialog dlg(path, NULL, this);
	dlg.m_ofn.lpstrTitle = title;
	if (dlg.DoModal() == IDOK)
		mIGCDLLDir.SetWindowText(dlg.GetPath());
}

BOOL CSettingsDialog::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	mIGCDLLDir.SetWindowText(theApp.mDLLDirectory);
	mDownloadDir.SetWindowText(theApp.mDownloadDirectory);
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CSettingsDialog::OnOK() 
{
	mIGCDLLDir.GetWindowText(theApp.mDLLDirectory);
	mDownloadDir.GetWindowText(theApp.mDownloadDirectory);
	
	CDialog::OnOK();
}

BOOL CSettingsDialog::OnHelpInfo(HELPINFO* pHelpInfo) 
{
	BOOL result = TRUE;

	if (pHelpInfo->iContextType == HELPINFO_WINDOW)
		AfxGetApp()->WinHelp(pHelpInfo->dwContextId, HELP_CONTEXTPOPUP);
	else
		result = CDialog::OnHelpInfo(pHelpInfo);

	return result;
}
